/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.desertmobs.entity;

import com.lycanitesmobs.ObjectManager;
import com.lycanitesmobs.api.IGroupAlpha;
import com.lycanitesmobs.api.IGroupAnimal;
import com.lycanitesmobs.api.IGroupHeavy;
import com.lycanitesmobs.api.IGroupPredator;
import com.lycanitesmobs.api.IGroupPrey;
import com.lycanitesmobs.core.entity.EntityCreatureAgeable;
import com.lycanitesmobs.core.entity.EntityCreatureTameable;
import com.lycanitesmobs.core.entity.ai.EntityAIAttackMelee;
import com.lycanitesmobs.core.entity.ai.EntityAIBeg;
import com.lycanitesmobs.core.entity.ai.EntityAIFollowOwner;
import com.lycanitesmobs.core.entity.ai.EntityAIStealth;
import com.lycanitesmobs.core.entity.ai.EntityAISwimming;
import com.lycanitesmobs.core.entity.ai.EntityAITargetAttack;
import com.lycanitesmobs.core.entity.ai.EntityAITargetOwnerAttack;
import com.lycanitesmobs.core.entity.ai.EntityAITargetOwnerRevenge;
import com.lycanitesmobs.core.entity.ai.EntityAITargetOwnerThreats;
import com.lycanitesmobs.core.entity.ai.EntityAITargetRevenge;
import com.lycanitesmobs.core.entity.ai.EntityAITempt;
import com.lycanitesmobs.core.entity.ai.EntityAIWander;
import com.lycanitesmobs.core.info.DropRate;
import com.lycanitesmobs.core.info.MobInfo;
import com.lycanitesmobs.core.info.ObjectLists;
import java.util.HashMap;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraft.world.World;

public class EntityCrusk
extends EntityCreatureTameable
implements IGroupPredator,
IGroupHeavy {
    public EntityCrusk(World world) {
        super(world);
        this.attribute = EnumCreatureAttribute.ARTHROPOD;
        this.defense = 3;
        this.experience = 10;
        this.hasAttackSound = true;
        this.babySpawnChance = 0.25;
        this.growthTime = -120000;
        this.setWidth = 5.8f;
        this.setDepth = 5.8f;
        this.setHeight = 1.8f;
        this.setupMob();
        this.hitAreaWidthScale = 1.5f;
    }

    @Override
    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming(this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIStealth(this).setStealthTime(60));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)this.aiSit);
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIFollowOwner(this).setStrayDistance(4.0).setLostDistance(32.0));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAITempt(this).setItem(new ItemStack(ObjectManager.getItem("crusktreat"))).setTemptDistanceMin(4.0));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIAttackMelee(this).setTargetClass(EntityPlayer.class).setLongMemory(false).setRate(60));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIAttackMelee(this).setRate(30));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAIWander(this));
        this.field_70714_bg.func_75776_a(9, (EntityAIBase)new EntityAIBeg(this));
        this.field_70715_bh.func_75776_a(0, (EntityAIBase)new EntityAITargetOwnerRevenge(this));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAITargetOwnerAttack(this));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAITargetRevenge(this));
        this.field_70715_bh.func_75776_a(3, (EntityAIBase)new EntityAITargetAttack(this).setTargetClass(EntityPlayer.class));
        this.field_70715_bh.func_75776_a(3, (EntityAIBase)new EntityAITargetAttack(this).setTargetClass(EntityVillager.class));
        this.field_70715_bh.func_75776_a(3, (EntityAIBase)new EntityAITargetAttack(this).setTargetClass(IGroupPrey.class));
        this.field_70715_bh.func_75776_a(3, (EntityAIBase)new EntityAITargetAttack(this).setTargetClass(IGroupAlpha.class));
        if (MobInfo.predatorsAttackAnimals) {
            this.field_70715_bh.func_75776_a(3, (EntityAIBase)new EntityAITargetAttack(this).setTargetClass(IGroupAnimal.class));
            this.field_70715_bh.func_75776_a(3, (EntityAIBase)new EntityAITargetAttack(this).setTargetClass(EntityAnimal.class));
        }
        this.field_70715_bh.func_75776_a(6, (EntityAIBase)new EntityAITargetOwnerThreats(this));
    }

    @Override
    protected void func_110147_ax() {
        HashMap<String, Double> baseAttributes = new HashMap<String, Double>();
        baseAttributes.put("maxHealth", 20.0);
        baseAttributes.put("movementSpeed", 0.24);
        baseAttributes.put("knockbackResistance", 0.5);
        baseAttributes.put("followRange", 16.0);
        baseAttributes.put("attackDamage", 4.0);
        super.applyEntityAttributes(baseAttributes);
    }

    @Override
    public void loadItemDrops() {
        this.drops.add(new DropRate(new ItemStack(Items.field_151119_aD), 1.0f).setMinAmount(6).setMaxAmount(12));
        this.drops.add(new DropRate(new ItemStack(Items.field_151145_ak), 0.5f).setMinAmount(1).setMaxAmount(3));
        this.drops.add(new DropRate(new ItemStack(Blocks.field_150366_p), 0.5f).setMinAmount(2).setMaxAmount(3));
        this.drops.add(new DropRate(new ItemStack(Blocks.field_150352_o), 0.25f).setMinAmount(1).setMaxAmount(2));
    }

    @Override
    public boolean canStealth() {
        if (this.isTamed() && this.isSitting()) {
            return false;
        }
        IBlockState blockState = this.func_130014_f_().func_180495_p(this.func_180425_c().func_177982_a(0, -1, 0));
        if (blockState.func_177230_c() != Blocks.field_150350_a) {
            if (blockState.func_185904_a() == Material.field_151578_c) {
                return true;
            }
            if (blockState.func_185904_a() == Material.field_151577_b) {
                return true;
            }
            if (blockState.func_185904_a() == Material.field_151584_j) {
                return true;
            }
            if (blockState.func_185904_a() == Material.field_151595_p) {
                return true;
            }
            if (blockState.func_185904_a() == Material.field_151571_B) {
                return true;
            }
            if (blockState.func_185904_a() == Material.field_151597_y) {
                return true;
            }
            if (blockState.func_185904_a() == Material.field_151596_z) {
                return true;
            }
        }
        return blockState.func_177230_c() == Blocks.field_150424_aL;
    }

    @Override
    public boolean canBeTempted() {
        return this.func_70631_g_();
    }

    @Override
    public boolean petControlsEnabled() {
        return true;
    }

    @Override
    public int getNoBagSize() {
        return 0;
    }

    @Override
    public int getBagSize() {
        return 5;
    }

    @Override
    public boolean isDamageTypeApplicable(String type) {
        if (type.equals("cactus")) {
            return false;
        }
        if (type.equals("inWall")) {
            return false;
        }
        return super.isDamageTypeApplicable(type);
    }

    @Override
    public boolean func_70687_e(PotionEffect potionEffect) {
        if (potionEffect.func_188419_a() == MobEffects.field_76438_s) {
            return false;
        }
        if (potionEffect.func_188419_a() == MobEffects.field_76437_t) {
            return false;
        }
        return super.func_70687_e(potionEffect);
    }

    @Override
    public EntityCreatureAgeable createChild(EntityCreatureAgeable baby) {
        return new EntityCrusk(this.func_130014_f_());
    }

    @Override
    public boolean isBreedingItem(ItemStack par1ItemStack) {
        return false;
    }

    @Override
    public boolean isTamingItem(ItemStack itemstack) {
        if (!this.func_70631_g_()) {
            return false;
        }
        return itemstack.func_77973_b() == ObjectManager.getItem("crusktreat");
    }

    @Override
    public boolean isHealingItem(ItemStack testStack) {
        return ObjectLists.inItemList("cookedmeat", testStack);
    }
}

